<?php
/*
Plugin Name: WP Speed Up China
Plugin URI:  https://www.kejianet.cn
Description: 专为国内环境优化：禁用头像/字体/Emoji/XML-RPC/评论；移除WP Logo/版本号；限制修订版本/自动草稿/Heartbeat，全方位极致加速。
Version:     1.6.0
Author:      QianYa
Author URI:  https://www.kejianet.cn
License:     GPL2
*/

if ( ! defined( 'ABSPATH' ) ) {
    exit; // 防止直接访问
}

// ==========================================
// 1. 基础加速 (头像、字体、Emoji)
// ==========================================

// 1.1 强制禁用 Gravatar 头像
add_filter( 'option_show_avatars', '__return_false' );

// 1.2 彻底移除 Google Fonts
function wsuc_remove_google_fonts() {
    global $wp_styles;
    if ( isset( $wp_styles->queue ) ) {
        foreach ( $wp_styles->queue as $handle ) {
            if ( isset( $wp_styles->registered[$handle] ) ) {
                $src = $wp_styles->registered[$handle]->src;
                if ( strpos( $src, 'fonts.googleapis.com' ) !== false || strpos( $src, 'fonts.gstatic.com' ) !== false ) {
                    wp_dequeue_style( $handle );
                    wp_deregister_style( $handle );
                }
            }
        }
    }
}
add_action( 'wp_print_styles', 'wsuc_remove_google_fonts', 999 );
add_action( 'admin_print_styles', 'wsuc_remove_google_fonts', 999 );
add_action( 'login_head', 'wsuc_remove_google_fonts', 999 );

// 1.3 移除 WordPress Emoji
function wsuc_remove_emojis() {
    remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
    remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
    remove_action( 'wp_print_styles', 'print_emoji_styles' );
    remove_action( 'admin_print_styles', 'print_emoji_styles' ); 
    remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
    remove_filter( 'comment_text_rss', 'wp_staticize_emoji' ); 
    remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );
    add_filter( 'tiny_mce_plugins', function( $plugins ) {
        return is_array( $plugins ) ? array_diff( $plugins, array( 'wpemoji' ) ) : array();
    });
}
add_action( 'init', 'wsuc_remove_emojis' );

// 1.4 移除 DNS 预解析
function wsuc_remove_dns_prefetch( $hints, $relation_type ) {
    if ( 'dns-prefetch' === $relation_type ) {
        return array_diff( $hints, array( '//s.w.org' ) );
    }
    return $hints;
}
add_filter( 'wp_resource_hints', 'wsuc_remove_dns_prefetch', 10, 2 );

// 1.5 禁止加载 Open Sans
function wsuc_remove_open_sans() {
    wp_deregister_style( 'open-sans' );
    wp_register_style( 'open-sans', false );
}
add_action( 'wp_enqueue_scripts', 'wsuc_remove_open_sans' );
add_action( 'admin_enqueue_scripts', 'wsuc_remove_open_sans' );


// ==========================================
// 2. 彻底禁用评论系统
// ==========================================

add_filter( 'comments_open', '__return_false', 20, 2 );
add_filter( 'pings_open', '__return_false', 20, 2 );
add_filter( 'comments_array', '__return_empty_array', 10, 2 );
add_action( 'admin_menu', function () { remove_menu_page( 'edit-comments.php' ); });
add_action( 'admin_bar_menu', function ( $wp_admin_bar ) { $wp_admin_bar->remove_node( 'comments' ); }, 999 );
add_action( 'init', function() {
    if ( is_comment_feed() ) {
        wp_die( '评论订阅已关闭。', '', array( 'response' => 403 ) );
    }
});


// ==========================================
// 3. 安全与头部清理
// ==========================================

// 3.1 禁用 XML-RPC
add_filter( 'xmlrpc_enabled', '__return_false' );
add_filter( 'xmlrpc_methods', function( $methods ) {
    unset( $methods['pingback.ping'] );
    return $methods;
} );
remove_action( 'wp_head', 'rsd_link' );
remove_action( 'wp_head', 'wlwmanifest_link' );

// 3.2 移除版本号
remove_action( 'wp_head', 'wp_generator' );

// 3.3 移除 jQuery Migrate
add_action( 'wp_default_scripts', function( $scripts ) {
    if ( ! is_admin() && isset( $scripts->registered['jquery'] ) ) {
        $script = $scripts->registered['jquery'];
        if ( $script->deps ) { 
            $script->deps = array_diff( $script->deps, array( 'jquery-migrate' ) );
        }
    }
} );


// ==========================================
// 4. 品牌净化 (去除 WordPress Logo)
// ==========================================

add_action( 'admin_bar_menu', function( $wp_admin_bar ) { $wp_admin_bar->remove_node( 'wp-logo' ); }, 999 );
add_action( 'login_enqueue_scripts', function() {
    echo '<style type="text/css">.login h1 a { background-image: none !important; display: none !important; }</style>';
});
add_filter( 'admin_footer_text', '__return_empty_string' );
add_filter( 'update_footer', '__return_empty_string', 11 );


// ==========================================
// 5. 数据库防臃肿 & 心跳限制 (新增核心优化)
// ==========================================

/**
 * 5.1 限制文章修订版本 (Post Revisions)
 * 说明：默认无限保存。每改一次存一条，数据库会爆炸。
 * 优化：只保留最后 3 个版本，够后悔用了。
 */
if ( ! defined( 'WP_POST_REVISIONS' ) ) {
    define( 'WP_POST_REVISIONS', 3 );
}

/**
 * 5.2 调整自动保存间隔 (Auto Save)
 * 说明：默认 60秒 自动保存一次，多人在后台时 CPU 压力大。
 * 优化：延长到 300秒 (5分钟)。
 */
if ( ! defined( 'AUTOSAVE_INTERVAL' ) ) {
    define( 'AUTOSAVE_INTERVAL', 300 );
}

/**
 * 5.3 限制 WordPress Heartbeat API (心跳检测)
 * 说明：后台会每隔 15-60秒 向服务器发送一次请求（检测登录状态、锁文章等）。
 * 优化：非必要页面彻底禁用，编辑页面延长到 60秒。防止长期打开后台导致服务器 CPU 持续占用。
 */
add_action( 'init', 'wsuc_stop_heartbeat', 1 );
function wsuc_stop_heartbeat() {
    global $pagenow;
    // 如果不是编辑文章页面，也不是新建文章页面，彻底禁用心跳
    if ( $pagenow != 'post.php' && $pagenow != 'post-new.php' ) {
        wp_deregister_script( 'heartbeat' );
    }
}

// 在编辑页面，将心跳频率降低到 60秒
add_filter( 'heartbeat_settings', 'wsuc_heartbeat_frequency' );
function wsuc_heartbeat_frequency( $settings ) {
    $settings['interval'] = 60; 
    return $settings;
}

/**
 * 5.4 禁用 REST API 的非登录用户访问 (可选，增强安全)
 * 说明：默认 API 是公开的，黑客可以通过 JSON 爬取你的所有用户列表和文章 ID。
 * 优化：除非已登录，否则禁止访问 /wp-json/wp/v2/users 等敏感端点。
 */
add_filter( 'rest_authentication_errors', function( $result ) {
    if ( ! empty( $result ) ) {
        return $result;
    }
    if ( ! is_user_logged_in() ) {
        // 如果你需要开发小程序或APP且不需要登录，请注释掉下面这行
        // return new WP_Error( 'rest_not_logged_in', 'You are not currently logged in.', array( 'status' => 401 ) );
    }
    return $result;
});

/**
 * 5.5 彻底移除 Feed (RSS 订阅)
 * 说明：企业站通常不需要 RSS，移除可防止爬虫无休止抓取。
 */
function wsuc_disable_feed() {
    wp_die( '本站不提供 Feed 订阅服务，请直接访问网站。' );
}
add_action('do_feed', 'wsuc_disable_feed', 1);
add_action('do_feed_rdf', 'wsuc_disable_feed', 1);
add_action('do_feed_rss', 'wsuc_disable_feed', 1);
add_action('do_feed_rss2', 'wsuc_disable_feed', 1);
add_action('do_feed_atom', 'wsuc_disable_feed', 1);
remove_action( 'wp_head', 'feed_links_extra', 3 );
remove_action( 'wp_head', 'feed_links', 2 );